//////////////////////////////////////////////
// Buffer.js
//
//////////////////////////////////////////////

/// Class ------------------------------------
	
nkGraphicsTests.Buffer = class Buffer extends nkDebug.TestClass
{
	static instance = new Buffer ("nkGraphicsTests.Buffer") ;

	// Tests
	testBufferSettingsLoad (bufferName, wantedUsage, wantedCpuAccess, wantedBind, data, expectedResult)
	{
		
	}

	nkTests =
	{
		__testInit__ : function ()
		{
			// Init nkGraphics
			const s = nkGraphics.System.getInstance() ;

			const initResult = s.initialize() ;

			if (!initResult)
				console.log("Failure to initialize nkGraphics, bypassing Buffer test...")

			return initResult ;
		},
		__testShutdown__ : function ()
		{
			nkGraphics.System.getInstance().shutdown()  ;
			nkGraphics.System.kill() ;
		},

		DefaultBufferLoad : function ()
		{
			// Create default buffer
			const buf = nkGraphics.BufferManager.getInstance().createOrRetrieve("TEST_BUF") ;

			// Some default values
			buf.setElementByteSize(4) ;
			buf.setElementCount(2) ;

			// This should load successfully
			nkDebug.TestUtils.check(buf.load(), "Empty buffer should load") ;
		},

	}
}